Remaining:=[1];#Progress
Progress:=0;#Progress
GlobalTimers:=[]; #rec(start,offset,current);

##########################  Progress
ResetProgress:=function() 
  Remaining:=[1];#Progress
  Progress:=0;#Progress
end;

UpdateProgress:=function(newcases)
  local case;
  case:=Remove(Remaining);
  if newcases=0 then 
    Progress:=Progress+1/case;
  else 
    Append(Remaining,List([1..newcases],z->case*newcases));
  fi;
end;

####################### Reports
Report:=function(arg) 
  local L,strs,values,len1,len2,n,i;
  strs:=arg[1];
  values:=arg{[2..Length(arg)]};
  strs:=SplitString(strs,"#");
  len1:=Length(strs);len2:=Length(values);
  if len1< len2 then 
    Append(strs,List([len1+1..len2],z->""));
  elif len2< len1 then 
    Append(values,List([len2+1..len1],z->""));
  fi;
  len1:=Length(strs);
  L:=[];
  for i in [1..len1] do 
    L[2*i-1]:=strs[i];
    L[2*i]:=values[i];
  od;
  CallFuncList(Print,L);
end;

ReportRec:=function(r) 
  local format,name,last,str,strm;
  str:="";
  strm:=OutputTextString(str,true);
  if IsBound(r.format) then
    #Affects the order in which the fields are reported. 
    #Fields not listed here are omitted.
    #fields not present in RecNames(r) are printed literally.
    format:=r.format; 
  else 
    format:=RecNames(r); 
  fi;
  last:=format[Length(format)];
  for name in format do 
    if not name in RecNames(r) then 
      PrintTo(strm,name);
    else 
      PrintTo(strm,name,": ",r.(name));
      if name<>last then
        PrintTo(strm,", ");
      else
        PrintTo(strm,".\n");
      fi;
    fi;  
  od;
  CloseStream(strm);
  Print(str);
end;

##############################################
#Truncate to tree significan digits.
#String may contain units like " ms", " years".
#The space before the unis is required.
TruncateFloat:=function(str)
  local len,posexp,pospoint,posspace,str1,str2,str3,count,i;
  if str="--" then return str; fi;
  len:=Length(str);
  pospoint:=Position(str,'.');
  posexp:=Position(str,'e');
  if posexp=fail then posexp:=len+1; fi;
  posspace:=Position(str,' ');
  if posspace=fail then posspace:=len+1; fi;
  posexp:=Minimum(posexp,posspace);
  str1:=str{[1..pospoint]};
  str2:=str{[pospoint+1..posexp-1]};
  str3:=str{[posexp..len]};
  if str1="0." then
    count:=0;
    for i in [1..Length(str2)] do 
      if str2[i] in "123456789" then count:=count+1; fi;
      if count>=3 then break; fi;
    od;
    if count>=3 then 
      str2:=str2{[1..i]};
    fi;
    return Concatenation(str1,str2,str3);
  else
    count:=Length(str1)-1;
    return Concatenation(str1,str2{[1..Minimum(3-count,Length(str2))]},str3);    
  fi;
end;

############################### Timers

HumanTime:=function(time) #time in nanoseconds 
  local scales, units, n, i;
  if IsString(time) then return time; fi;
  if IsInt(time) then time:=Float(time); fi;
  scales:=[10.^3,10.^3,10.^3,60.,60.,24.,30.,365./30.];
  units:=["ns","µs","ms","s","min","h","days","months","years"];
  n:=Length(scales);
  for i in [1..n] do 
    if time<scales[i] then
      return Concatenation(String(time)," ",units[i]);
    else
      time:=time/scales[i];
    fi;
  od;
  return Concatenation(String(time)," ",units[n+1]);    
end;

THumanTime:=function(time) #time in nanoseconds 
  return TruncateFloat(HumanTime(time));  
end;

ResetTimer:=function(arg)
  local timer,r;
  if arg=[] then timer:=1; else timer:=arg[1]; fi;
  r:=rec();
  r.start:= TimeInSeconds()*10^9; #Starting time in nanoseconds since 1970.
  r.nanos:= NanosecondsSinceEpoch(); #updated everytime NanoElapsedtime() is called. 
  r.offset:= r.nanos; #updated every 100 seconds when NanoElapsedTime() is called.
  r.current:= 0; #current elapsed time. updated every 100 seconds when NanoElapsedTime() is called.
  #Real time = TimeInSeconds()*10^9 - r.start. but is slow to compute.
  #Best estimate = r.current+(r.nanos-r.offset). faster.
  GlobalTimers[timer]:=r;
end;

# AdjustTimer after an interruption.
# Only if |diff| > 10^9 ns = 1 second. Human scale interruption. 
# Assumes that the last computed ElapsedTime is 
# the correct and not the one we could compute now. 
AdjustTimer:=function(arg)
   local r,nanos,diff,timer;
   if arg=[] then timer:=1; else timer:=arg[1]; fi;
   r:=GlobalTimers[timer];
   nanos:=NanosecondsSinceEpoch();
   diff:=nanos-r.nanos;
   if AbsInt(diff)>10^9 then
     Report("*** TimeAdjust(#) = #\n",timer,THumanTime(diff));
     r.start:=r.start+diff; #takes effect only after 100 seconds.
     r.current:= r.current+(r.nanos-r.offset); #best estimate.
     r.nanos:=nanos;
     r.offset:=r.nanos;
   fi;
end;

NewTimer:=function() 
  local timer,r;
  timer:=Length(GlobalTimers)+1;
  ResetTimer(timer);
  return timer;
end;

# Elapsed time in nanoseconds since ResetTimer(). 
#   NanosecondsSinceEpoch() is fast but not reliable to measure hours.
#   TimeInSeconds() is accurate but is slow.
#   Monotonicity is very probable but not guarantied. 
#   NanosecondsSinceEpoch() typically done in 28 microseconds
#   TimeInSeconds() typically done in 4,700 microseconds
#   Not to be called too often.
NanoElapsedTime:=function(arg)
  local timer,diff,r;
  if arg=[] then timer:=1; else timer:=arg[1]; fi;
  if not IsBound(GlobalTimers[timer]) then 
    ResetTimer(timer); 
    return 0;
  fi;
  r:=GlobalTimers[timer];
  r.nanos:=NanosecondsSinceEpoch();
  diff:=r.nanos-r.offset;
  if diff<10^11 then #100 seconds.
    return r.current+diff;
  else
    r.offset:=r.nanos;
    r.current:=TimeInSeconds()*10^9-r.start;
    return r.current;          
  fi;
end;

#Elapsed Time in human-readable form.
ElapsedTime:=function(arg) 
   return THumanTime(CallFuncList(NanoElapsedTime,arg));
end;

#ETC = Estimated Time for Completion in nanoseconds.
NanoETC:=function(arg) 
  local etc,t,timer;
  if arg=[] then timer:=1; else timer:=arg[1]; fi;  
  if Progress=0 then return "--"; fi;
  if IsBound(arg[2]) then
    t:=arg[2];#when called just after t=NanoElapsedTime();
  else
    t:=NanoElapsedTime(timer);
  fi;
  etc:=Float(t/Progress-t);
  return etc;
end;

#ETC = Estimated Time for Completion in human-readable form.
ETC:=function(arg)
  return THumanTime(CallFuncList(NanoETC,arg));
end;

#ETC based on Recent history.
ETCR:=function(Hist) 
  local len,et1,et2,prog1,prog2,DeltaT,DeltaP,Rem,etrc;
  if Length(Hist)<2 then return "--"; fi;
  len:=Length(Hist);
  et1:=Hist[1][1];#elapsed time
  prog1:=Hist[1][2];#progress
  et2:=Hist[len][1];
  prog2:=Hist[len][2];
  DeltaP:=prog2-prog1;
  if DeltaP<=0 then return "--"; fi;
  DeltaT:=et2-et1;
  Rem:=1-Progress; #Remainig work.
  etrc:=Float(DeltaT*Rem/DeltaP);
  return THumanTime(etrc);
end;


############################## Reports OPS.

#Report Once Per Second.
ReportOPS:=function(arg) 
  local et;
  et:=NanoElapsedTime(3);
  if et=0 then CallFuncList(Report,arg); fi; #initial report.
  if et < 10^9 then 
    return; 
  fi;
  ResetTimer(3);
  CallFuncList(Report,arg);
end;

#Report Once Per Second.
ReportRecOPS:=function(r) 
  local et;
  et:=NanoElapsedTime(3);
  if et=0 then ReportRec(r); fi; #initial report.
  if et < 10^9 then 
    return;
  fi;
  ResetTimer(3);
  ReportRec(r); 
end;

