############################################
#
# Survey data.
#
############################################

SurveyTable:=[];
data:=[];
fdata:=[];
udata:=[];

AllDirs:=["DataPrev","Data10u","Data10","Data"];

#Parity: 
#g even => MB even.
#g odd and d even => MB odd
#g odd and d odd => MB even
MooreBound:=function(d,g)
   local top,s;
   if IsOddInt(g) then 
     top:=(g-3)/2;
     s:=Sum(List([0..top],z->(d-1)^z));
     return 1+d*s;
   else #Even
     top:=(g-2)/2;
     s:=Sum(List([0..top],z->(d-1)^z));
     return 2*s;
   fi;
end;

KovacsCondition:=function(d) 
  local radix1,radix2;
  #d can not be expressed as d=s^2+s-1 for some integer s and
  #d can not be expressed as d=s^2+s+3 for some integer s <-- this is not said in the survey.
  radix1:=Sqrt(4*d+5);
  radix2:=Sqrt(4*d-11);
  if IsInt(radix1) and IsOddInt(radix1) and radix1>1 then return false; fi;
  if IsInt(radix2) and IsOddInt(radix2) and radix2>1 then return false; fi;
  return true;
  # if not IsInt(radix1) then return true; fi;
  # if not IsOddInt(radix1) then return true; fi;
  # return false;
end;

IsSumOfTwoSquares:=function(s) 
  local factors;
  factors:=FactorsInt(s);
  factors:=Filtered(factors,z-> (z mod 4) = 3);
  if factors=[] then return true; fi;
  factors:=Collected(factors);
  factors:=List(factors,z->z[2]);
  return ForAll(factors,IsEvenInt);
end;

BruckRyserCondition:=function(d,g)
  if g = 6 and not IsPrimePowerInt(d-1) and (d mod 4) in [2,3]
           and not IsSumOfTwoSquares(d-1) then 
      return true;
  fi;
  return false;
end;

BestLowerBoundExplain:=function(d,g) 
  local mb,blb,blb0,pos,cases,sol,explain,newlowerbound,parity;
  
  newlowerbound:=function(cond,new)
    if [d,g] = cond and blb< new[1] then
      blb:=new[1];Add(explain,new);
    fi;
  end;
  
  parity:=function() 
    if IsOddInt(d) and IsOddInt(blb) then 
      blb:=blb+1;Add(explain,[blb,"parity",1947]);  
    fi;
  end;

  mb:=MooreBound(d,g);
  blb:=mb;blb0:=0;
  explain:=[[blb,"Moore",1960]];
  
  while(blb0<blb)do 
     blb0:=blb; 
     newlowerbound([4,5],[19,"Robertson",1964]);
     if blb=mb and BruckRyserCondition(d,g) then 
       blb:=blb+1;Add(explain,[blb,"Bruck, Ryser",1949]);parity();fi; #OK
     if blb=mb+1 and g=5 then 
       blb:=blb+1;Add(explain,[blb,"Brown", 1967]);parity();fi; #OK
     newlowerbound([5,5],[30,"Wegner",1973]);
     if blb=mb and not (d=2 or g=3 or g=4 or (g=5 and d in [2,3,7,57])
                        or g in [6,8,12]) then 
       blb:=blb+1;Add(explain,[blb,"Bannai, Ito; Damarel",1973]);parity();fi; #OK
    newlowerbound([6,5],[40,"O'Keefe, Wong 1",1979]);
    newlowerbound([3,10],[70,"O'Keefe, Wong 2",1980]);
    if blb=mb+1 and g>= 6 and IsEvenInt(g) and d>= 3 then 
       blb:=blb+1;Add(explain,[blb,"Biggs, Ito 1", 1980]);parity();fi;#OK
    if blb=mb+2 and g>= 6 and IsEvenInt(g) and (g>6  or  (d mod 8) in [5,7]) then 
      blb:=blb+1;Add(explain,[blb,"Biggs, Ito 2",1980]);parity();fi;#OK
    newlowerbound([7,6],[90,"O'Keefe, Wong 3",1981]);
    if blb=mb+2 and g=5 and IsOddInt(d) and d>=3 and KovacsCondition(d) then 
       blb:=blb+1;Add(explain,[blb,"Kovacs",1981]);parity();fi; #OK
    if blb=mb+1 and g>= 5 and IsOddInt(g) and d>= 3 then 
       blb:=blb+1;Add(explain,[blb,"Bannai, Ito",1981]);parity();fi; #OK
    if blb=mb and g=6 and d=11 then 
       blb:=blb+1;Add(explain,[blb,"Lam, Thiel, Swiercz",1989]);parity();fi; #OK
    newlowerbound([3,9],[58,"Brinkmann, McKay, Saager",1995]); 
    newlowerbound([3,11],[112,"McKay, Myrvold, Nadon 1",1998]); 
    newlowerbound([3,13],[202,"McKay, Myrvold, Nadon 2",1998]); 
    newlowerbound([3,14],[258,"McKay, Myrvold, Nadon 3",1998]); 
    if blb=mb+2 and g=5 and d in [5..11] then 
       blb:=blb+1;Add(explain,[blb,"Eroh, Schwenk",1999]);parity();fi; #OK
    if blb=mb+1 and g=7 then 
       blb:=blb+1;Add(explain,[blb,"Eroh, Schwenk 2",1999]);parity();fi; #OK
    newlowerbound([4,7],[67,"Exoo, McKay, Myrvold, Nadon 1",2011]); 
    newlowerbound([3,14],[260,"Exoo, McKay, Myrvold, Nadon 2",2011]);
    parity();
  od;
  return explain;    
end;

BestLowerBound:=function(d,g) 
  local blb;
  blb:=BestLowerBoundExplain(d,g);
  blb:=blb[Length(blb)];
  blb:=blb[1];
  return blb;
end;

BestUpperBound:=function(d,g) 
  local data;
  if d=2 then return g; fi;
  if g=3 then return d+1; fi;
  if g=4 then return 2*d; fi;
  if d=3 then
    data:=First(SurveyTable[3],z->z[1]=[d,g]);
    if data = fail then return fail; fi;
    return data[3];
  fi;
  data:=First(SurveyTable[6],z->z[1]=[d,g]);
  if data = fail then return fail; fi;
  return data[2];
end;

############################################
#
# Our data.
#
############################################

Read("ourdata.g");;
#######################################
#data:=CollectAndReduce(AllDirs);;
#fdata:=Finished(data);;
#udata:=Unfinished(data);;
########################################
    
StrTimeToNanoSec:=function(str)
  local Lstr,time,units,scales,pos;
  scales:=[1,10^3,10^6,10^9,60*10^9,60*60*10^9,24*60*60*10^9,30*24*60*60*10^9,365*24*60*60*10^9];
  units:=["ns","µs","ms","s","min","h","days","months","years"];
  Lstr:=SplitString(str," ");
  time:=Float(Lstr[1]);
  pos:=Position(units,Lstr[2]);
  time:=time*scales[pos];
  return time; 
end;

CollectData:=function(Dirs)
  local Dir,command,strm,file,files,data;
  data:=[];
  if IsString(Dirs) then Dirs:=[Dirs]; fi; 
  for Dir in Dirs do
    command := StringFormatted("ls {}/state* > files",Dir);
    Exec(command);
    strm:=InputTextFile("files");
    files:=ReadAll(strm);
    CloseStream(strm);
    files:=SplitString(files,"\n");
    for file in files do
      Read(file);#Destroys state, Remaining,Progress,GlobalTimers,usePrevCons1.
      state.Datadir:=Dir;
      Add(data,state);
    od;
  od;
  return data;
end;

ReduceData:=function(data) 
  #[dgn,Version,NumSols,Htime,ntime,Progress,HETC,nETC].
  local data0,case,reduced,time;
  data0:=[];
  for case in data do
    if case.ETC="--" then continue; fi;
    reduced:=[case.dgn,Concatenation(case.Datadir,case.Suffix),case.NumSols,case.ET];
    time:=reduced[4];
    time:=StrTimeToNanoSec(time);
    Add(reduced,time);
    Add(reduced,case.Progress);
    Add(reduced,case.ETC);
    Add(reduced,StrTimeToNanoSec(case.ETC));
    Add(data0,reduced);
  od;
  Sort(data0,{x,y}->Float(x[8])>Float(y[8])); #Sort ETC
  StableSort(data0,{x,y}->x[5]<y[5]); #Sort by ntime
  #StableSort(data0,{x,y}->x[2]<y[2]);
  StableSort(data0,{x,y}->x[1]<y[1]); #SortBy dgn
  return data0;
end;

CollectAndReduce:=function(Dirs) 
  local data0;
  data0:=ReduceData(CollectData(Dirs));
  return data0;
end;

Finished:=function(data) 
  local data0;
  data0:=Filtered(data,z->not IsFloat(z[6]) or z[6]=1.);
  return data0;
end;

Unfinished:=function(data) 
  local data0;
  data0:=Filtered(data,z->IsFloat(z[6]) and z[6]<>1.);
  return data0;
end;

UpdateOurData:=function(Dirs) 
  data:=CollectAndReduce(Dirs);
  fdata:=Finished(data);
  udata:=Unfinished(data);
  PrintTo("ourdata.g","data:=\n");
  AppendTo("ourdata.g",data);
  AppendTo("ourdata.g",";\n\nfdata:=\n");
  AppendTo("ourdata.g",fdata);
  AppendTo("ourdata.g",";\n\nudata:=\n");
  AppendTo("ourdata.g",udata);
  AppendTo("ourdata.g",";\n");
end;

BestLowerBoundAsInPaper:=function(d,g)
  local n,mb,next;

  next:=function()
    n:=n+1;
    if IsOddInt(d) and IsOddInt(n) then 
      n:=n+1;
    fi;
  end;

  mb:=MooreBound(d,g);
  n:=mb;
  if n=mb and (g in [3,4]  or d=2) then return n; fi;
  if n=mb and (g=5 and d in [2,3,7]) then return n; fi;
  if n=mb and (g in [6,8,12] and IsPrimePowerInt(d-1)) then return n; fi;
  #####################
  if n=mb and (not g in [3,4,5,6,8,12] and d<>2) then next(); fi;
  if n=mb and (g=5 and not d in [2,3,7,57]) then next(); fi;
  if n=mb and (g=6 and d=11) then next(); fi;
  if n=mb and BruckRyserCondition(d,g) then next(); fi;
  #####################
  if n=mb+1 and (g=5) then next(); fi;
  if n=mb+1 and (g=7) then next(); fi;
  if n=mb+1 and (IsOddInt(g) and g>=5 and d>=3) then next(); fi;
  if n=mb+1 and (IsEvenInt(g) and g>=6 and d>=3) then next(); fi;
  ##################### 
  if n=mb+2 and (g=5 and d in [5,6,7,8,9,10,11]) then next(); fi;
  if n=mb+2 and (g=6 and (d mod 8) in [5,7]) then next(); fi;
  if n=mb+2 and (IsEvenInt(g) and g>= 8) then next(); fi;
  if n=mb+2 and (g=5 and IsOddInt(d) and d>=3 and
                KovacsCondition(d)) then next(); fi;
  ##################### Exact bounds
  if [d,g]=[3,7] then return 24; fi;
  if [d,g]=[3,9] then return 58; fi;
  if [d,g]=[3,10] then return 70; fi;
  if [d,g]=[3,11] then return 112; fi;
  if [d,g]=[4,5] then return 19; fi;
  if [d,g]=[4,7] then return 67; fi;
  if [d,g]=[5,5] then return 30; fi;
  if [d,g]=[6,5] then return 40; fi;
  if [d,g]=[7,6] then return 90; fi;
  ##################### Computational lower bounds
  if [d,g]=[3,13] then return 202; fi;
  if [d,g]=[3,14] then return 260; fi;
  #####################
  return n;
end;

#operates on fdata in "ourdata.g".
OurBestLowerBoundExplain:=function(d,g) 
  local data0;
  data0:=Filtered(fdata,z->z[1]{[1,2]}=[d,g]);
  return data0;
end;

#operates on fdata in "ourdata.g".
OurBestLowerBounds:=function(d,g) 
  local data0,max,delta,bounds;
  delta:=1+(d mod 2);
  data0:=OurBestLowerBoundExplain(d,g);
  bounds:=Set(List(data0),z->z[1][3]);
  if bounds=[] then return []; fi;
  max:=Maximum(bounds);
  data0:=Filtered(data0,z->z[1][3]=max);
  if data0[1][3]=0 then #Zero solutions for n=max.
    Add(bounds,max+delta);
  fi;
  return bounds;
end;

#operates on fdata in "ourdata.g".
OurBestLowerBoundRange:=function(d,g) 
  local bounds,min,max,omax,delta;
  bounds:=OurBestLowerBounds(d,g);
  if bounds=[] then return bounds; fi;
  min:=Minimum(bounds);max:=Maximum(bounds);delta:=1+(d mod 2);
  if min > MooreBound(d,g) then return []; fi;
  if bounds = [min,min+delta..max] then return [min,min+delta..max]; fi;#normal
  Print(TextAttr.(1),"Warning: Non-Contigous Range\n\n",TextAttr.(7));
  for omax in [min,min+delta..max+delta] do 
    if not omax in bounds then
      return [min,min+delta..omax-delta];
    fi;
  od;
  return bounds;
end;

#operates on fdata, udata in ourdata.g
OurBestPartialResultsExplain:=function(d,g) 
  local data0,data1;
  data1:=Filtered(data,z->z[1]{[1,2]}=[d,g]);
  return data1;
end;

#operates on fdata in "ourdata.g".
OurBestLowerBound:=function(d,g) 
  local bounds;
  bounds:=OurBestLowerBoundRange(d,g);
  if bounds=[] then return fail; fi; 
  return Maximum(bounds);
end;

CheckTable:=function(n) 
  local case,d,g,blb,oblb,errors;
  errors:=[];
  
  if not n in [3,4,5] then
    Print("n should belong to [3,4,5] in CheckTable(n).\n");
    return errors;
  fi;
  
  for case in SurveyTable[n] do
    d:=case[1][1];g:=case[1][2];
    blb:= BestLowerBound(d,g);
    oblb:= OurBestLowerBound(d,g);
    if case[2]< blb then
      Print(TextAttr.(1),"<<<< ");Add(errors,[d,g]);
    elif case[2] > blb then
      Print(TextAttr.(1),">>>> ");Add(errors,[d,g]);
    fi;
    if oblb<> fail and case[2]< oblb then
      Print(TextAttr.(2),"<<<< ");Add(errors,[d,g]);
    elif oblb <> fail and case[2] > oblb then
      Print(TextAttr.(3),">>>> ");Add(errors,[d,g]);
    fi;
    Print(case[1]," ",case[2]," ",BestLowerBound(d,g)," ",OurBestLowerBound(d,g),TextAttr.(7),"\n");
  od;
  return errors;
end;

CheckBounds:=function(d,g)
  local blb,oblb;
  blb:=BestLowerBound(d,g);
  oblb:=OurBestLowerBound(d,g);
  return [[d,g],blb,oblb];
end;

TableBestLowerBound:=function(d,g) 
  local case,tbound;
  if d=3 then
    case:=First(SurveyTable[3],z->z[1]=[d,g]);
    if case = fail then return fail; fi;
    return case[2];
  elif g=5 then
    case:=First(SurveyTable[4],z->z[1]=[d,g]);
    if case = fail then return fail; fi;
    return case[2];
  elif g=6 then
    case:=First(SurveyTable[5],z->z[1]=[d,g]);
    if case = fail then return fail; fi;
    return case[2];
  else
    return fail; 
  fi;
end;

CheckBoundsList:=function(Ld,Lg) 
  local d,g,tblb,blb,oblb;
  for d in Ld do 
    for g in Lg do
      tblb:=TableBestLowerBound(d,g);
      blb:=BestLowerBound(d,g);
      oblb:=OurBestLowerBound(d,g);
      if tblb <> fail and tblb < blb then
        Print(TextAttr.(1),"<<<< ");
      elif tblb<>fail and tblb > blb then
        Print(TextAttr.(1),">>>> ");
      fi;
      if oblb<> fail and blb < oblb then
        Print(TextAttr.(2),"<<<< ");
      elif oblb <> fail and blb > oblb then
        Print(TextAttr.(3),">>>> ");
      fi;
      Print([d,g]," ",tblb," ",blb," ",oblb,TextAttr.(7),"\n");
    od;
  od;
end;

MakeTable:=function(Ld,Lg) 
  local d,g,str,str1,mb,blb,oblb,bub;
  PrintTo("table.tex","\n");
  for d in Ld do
    str:="";
    for g in Lg do
      mb:=MooreBound(d,g);
      blb:=BestLowerBound(d,g);
      oblb:=OurBestLowerBound(d,g);
      bub:=BestUpperBound(d,g);
      if blb=fail then blb:="-"; fi;
      if oblb=fail then oblb:="-"; fi;
      if bub=fail then bub:="-"; fi;
      str1:=StringFormatted("\\bounds{{{},{},{},{}}}&",mb,blb,oblb,bub);
      Append(str,str1);
    od;
    Remove(str);
    Append(str,"\\\\\n");
    AppendTo("table.tex",str);
    Print(str);
  od;
end;

############################## Reescribir 3 funciones.
TimesBySuffix:=function(L) #L =fdata
  #[lab,NumCases,nTime,HTime]
  local labs,lab,ll,tims,sum,lis;
  labs:=Set(List(L,z->z[2]));
  lis:=[];
  for lab in labs do
    ll:=Filtered(L,z->z[2]=lab);
    ll:=Filtered(ll,z->z[1] in MostCases);
    if Length(ll)<> Length(MostCases) then continue; fi;
    sum:=Sum(List(ll,w->w[5]));#6
    tims:=THumanTime(sum);
    Add(lis,[lab,Length(ll),sum,tims]);
  od;
  Sort(lis,{x,y}->Float(x[3])<Float(y[3]));
  return lis;
end;

Winners:=function(L)#L=fdata 
  local lis,len,cases,case,labs,tims,lessthan;
  lessthan:=function(x,y) 
    if x[1]<y[1] then return true; fi;
    if x[1]>y[1] then return false; fi; 
    if Float(x[3])<=Float(y[3]) then return true; fi;
    return false;
  end;
  lis:=List(L,z->[z[1],z[2],z[5]]);
  Sort(lis,lessthan);
  return lis;
end;

#checks correct number of solutions.
#ref:=Filtered(data07r,z->z[2]="Data07F3TI");;
CheckCompat:=function(ref,L) 
  local z,pos;
  for z in L do
    pos:=PositionSorted(ref,[z[1]]);
    if ref[pos][5]<> z[5] then 
      Error("Difference found\n");
    fi;
  od;
  return true;
end;

###########################################################
#
#  Survey tables.
#
###########################################################

#Table 1 in survey: known trivalent cages.
#[[d,g],n,Num]
SurveyTable[1]:=[
[[3,5],10,1],
[[3,6],14,1],
[[3,7],24,1],
[[3,8],30,1],
[[3,9],58,18],
[[3,10],70,3],
[[3,11],112,1],
[[3,12],126,1]];

#Table 2 in survey: known cages of girth 5.
#[[d,g],n,Num]
SurveyTable[2]:=[
[[3,5],10,1],
[[4,5],19,1],
[[5,5],30,4],
[[6,5],40,1],
[[7,5],50,1]];

#Table 3 in survey: d=3.
#[[d,g],m,M,Num,who]
SurveyTable[3]:=[
[[3,5],     10,     10, 1,"Petersen"],
[[3,6],     14,     14, 1,"Heawood"],
[[3,7],     24,     24, 1,"McGee"],
[[3,8],     30,     30, 1,"Tutte"],
[[3,9],     58,     58,18,"Brinkmann-McKay-Saager"],
[[3,10],    70,     70, 3,"O'Keefe-Wong"],
[[3,11],   112,    112, 1,"McKay-Myrvold;Balaban"],
[[3,12],   126,    126, 1,"Benson"],
[[3,13],   202,    272,  ,"McKay-Myrvold;Hoare"],
[[3,14],   258,    384,  ,"MacKay;Exoo"],## Error: 260 in Exoo's paper.
[[3,15],   384,    620,  ,"Biggs"],
[[3,16],   512,    960,  ,"Exoo"],
[[3,17],   768,   2176,  ,"Exoo"],
[[3,18],  1024,   2560,  ,"Exoo"],
[[3,19],  1536,   4324,  ,"Hoare, H(47)"],
[[3,20],  2048,   5376,  ,"Exoo"],
[[3,21],  3072,  16028,  ,"Exoo"],
[[3,22],  4096,  16206,  ,"Biggs-Hoare, S(73)"],
[[3,23],  6144,  49326,  ,"Exoo"],
[[3,24],  8192,  49608,  ,"Bray-Parker-Rowley"],
[[3,25], 12288, 108906,  ,"Exoo"],
[[3,26], 16384, 109200,  ,"Bray-Parker-Rowley"],
[[3,27], 24576, 285852,  ,"Bray-Parker-Rowley"],
[[3,28], 32768, 415104,  ,"Bray-Parker-Rowley"],
[[3,29], 49152,1141484,  ,"Exoo-Jajcay"],
[[3,30], 65536,1143408,  ,"Exoo-Jajcay"],
[[3,31], 98304,3649794,  ,"Bray-Parker-Rowley"],
[[3,32],131072,3650304,  ,"Bray-Parker-Rowley"]];
                                                               
#Table 4 in survey: g=5.
#[[d,g],m,M,who]
SurveyTable[4]:=[
[[3,5],  10, 10,"Petersen"],
[[4,5],  19, 19,"Robertson"],
[[5,5],  30, 30,"Robertson-Wegner-Wong"],
[[6,5],  40, 40,"Wong"],
[[7,5],  50, 50,"Hoffman-Singleton"],
[[8,5],  67, 80,"Royle"],
[[9,5],  86, 96,"Jorgensen"],
[[10,5],103,124,"Exoo"],
[[11,5],124,154,"Exoo"],
[[12,5],147,203,"Exoo"],
[[13,5],174,230,"Exoo"],
[[14,5],199,288,"Jorgensen"],
[[15,5],230,312,"Jorgensen"],
[[16,5],259,336,"Jorgensen"],
[[17,5],294,448,"Schwenk"],
[[18,5],327,480,"Schwenk"],
[[19,5],364,512,"Schwenk"],
[[20,5],403,576,"Jorgensen"]];
                                               
#Table 5 in survey: g=6.
#[[d,g],m,M,who]
SurveyTable[5]:=[
[[3,6],   14, 14,"Projective Plane"],
[[4,6],   26, 26,"Projective Plane"],
[[5,6],   42, 42,"Projective Plane"],
[[6,6],   62, 62,"Projective Plane"],
[[7,6],   90, 90,"O'Keefe-Wong"],
[[8,6],  114,114,"Projective Plane"],
[[9,6],  146,146,"Projective Plane"],
[[10,6], 182,182,"Projective Plane"],
[[11,6], 224,240,"Wong"],
[[12,6], 266,266,"Projective Plane"],
[[13,6], 314,336,"Abreu-Funk-Labbate-Napolitano"],
[[14,6], 366,366,"Projective Plane"],
[[15,6], 422,462,"Abreu-Funk-Labbate-Napolitano"],
[[16,6], 482,504,"Abreu-Funk-Labbate-Napolitano"],
[[17,6], 546,546,"Projective Plane"],
[[18,6], 614,614,"Projective Plane"],
[[19,6], 686,720,"Abreu-Funk-Labbate-Napolitano"],
[[20,6], 762,762,"Projective Plane"]];

#Table 6 in survey: upper bounds.
#[[d,g],M]
SurveyTable[6]:=[
# row 3
[[3,5],  10],[[3,6],  14],[[3,7],  24],[[3,8],  30],[[3,9],  58],[[3,10], 70],[[3,11],112],
[[3,12],126],[[3,13],272],[[3,14],384],[[3,15],620],[[3,16],960],
# row 4
[[4,5],  19],[[4,6],  26],[[4,7],  67],[[4,8],  80],[[4,9], 275],[[4,10],384],
   #[[4,11],"unk"],
[[4,12],728],
# row 5
[[5,5],30],[[5,6],42],[[5,7],152],[[5,8],170],
   #[[5,9],"unk"],
[[5,10],1296],[[5,11],2688],[[5,12],2730],
#row 6
[[6,5],40],[[6,6],62],[[6,7],294],[[6,8],312],[[6,12],7812],
#Sporadic
[[9,7],1152],[[9,11],74752],
#column 5 
[[7,5],50],[[8,5],80],[[9,5],96],[[10,5],124],[[11,5],154],[[12,5],203],[[13,5],230],[[14,5],288],
[[15,5],312],[[16,5],336],[[17,5],448],[[18,5],480],[[19,5],512],[[20,5],576],
#column 6
[[7,6],90],[[8,6],114],[[9,6],146],[[10,6],182],[[11,6],240],[[12,6],266],[[13,6],336],
[[14,6],366],[[15,6],462],[[16,6],504],[[17,6],546],[[18,6],614],[[19,6],720],[[20,6],762],
#column 8
[[7,8],672],[[8,8],800],[[9,8],1170],[[10,8],1640],[[11,8],2618],[[12,8],2928],[[13,8],4342],
[[14,8],4760],[[15,8],7648],[[16,8],8092],[[17,8],8738],[[18,8],10440],[[19,8],13642],[[20,8],14480],
#column 12
[[7,12],32928],[[8,12],39216],[[9,12],74898],[[10,12],132860],[[11,12],319440],[[12,12],354312],
[[13,12],738192],[[14,12],804468],[[15,12],1957376],[[16,12],2088960],[[17,12],2236962],
[[18,12],3017196],[[19,12],4938480],[[20,12],5227320],
];
