usePrevCons1:=0; #selector for method PrevCons().
# This value is rewritten in cages.g


######################################
###########   PrevCons 1  ############
######################################
# Discards by filling holes. 

########################################
# lg = last g = () by default.
# LGrp= list of stabilizers of V when known.
#     starting with Grp, the original group.
#     LGrp=[Grp] by default.
############### 
# Grp is group, V is vector, S is vector (set).
# determines whether there is g in Grp such that 
# for each v in V there is s in S such that 
# v = s^g 
Cover:=function(Grp,V,S) 
   local i,v,s,g,BLs,Lspos,lg,Lg,pos,LGrp;
   if Length(V)>Length(S) then return fail; fi;
   BLs:=BlistList(S,[]);Lspos:=[];Lg:=[];i:=1;lg:=();
   if V=[] then return lg; fi;
   LGrp:=[Grp];
   while Length(Lspos)< Length(V) do 
     if not IsBound(Lspos[i]) then #first 
       Lspos[i]:=1;
     else #next
       Lspos[i]:=Lspos[i]+1;
     fi;
     
     g:=fail;
     for pos in [Lspos[i]..Length(S)] do
       if BLs[pos] then continue;fi; #already used 
       #s:=S[pos]; ## remove?
       g:=Transporter(LGrp[i],S[pos]^lg,V[i]);
       if g <> fail then 
         Lspos[i]:=pos;
         BLs[pos]:=true;
         break; 
       fi; 
     od;
     
     if g=fail then #back
       #Remove(Ls);Remove(Lg);Remove(LGrp);
       if i=1 then return fail; fi; #fail
       if IsBound(Lspos[i]) then Unbind(Lspos[i]); fi;  
       BLs[pos]:=false;
       #if IsBound(Lg[i]) then Unbind(Lg[i]); fi;  
       lg:=Lg[i-1];
       i:=i-1;
       continue;
     else #forward
       #Ls[i]:=s;
       lg:=lg*g;Lg[i]:=lg;
       if not IsBound(LGrp[i+1]) then 
         LGrp[i+1]:=yStab(LGrp[i],V[i]);
       fi;
       i:=i+1;
       continue;  
     fi;
  od;
  #test correctness.
  #NO: Print(V,"=",OnTuples(Ls,Lg[Length(Lg)]),"=",Ls,"^",Lg[Length(Lg)],"\n");
  return Lg[Length(Lg)];
end;

#Grp is a group, V is a Vector,
#S is auxiliary. S contains V and is Grp-invariant.
#Determines whether there is a g in G such that
#V^g < V and such that xn=Last(V) participates of
#this cover by covering a hole z.
CoverWithZrXn:=function(Grp,V,S) 
  local Grp1,lg,Z,V1,S1,n,xn,i,z;
  if V=[] then return false; fi;
  n:=Length(V);xn:=V[n];
  Z:=Filtered(S,z->z<xn);
  Z:=Difference(S,V);
  for z in Z do #Print("z=",z,"\n");
    lg:=Transporter(Grp,xn,z);
    if lg=fail then continue; fi;
    Grp1:=yStab(Grp,z);
    V1:=Filtered(V,w->w<z);
    S1:=Difference(V,[xn]);
    lg:=Cover(Grp1,V1,OnTuples(S1,lg));
    if lg = fail then continue; fi; 
    #Print(V,">",OnSets(Set(V),lg),"; lg = ",lg,"\n");#test correctness
    return lg; 
  od;
  return fail; 
end;

#Grp is a group, V is a Vector,
#S is auxiliary. S contains V and is Grp-invariant.
#Determines whether there is a g in G such that
#V^g < V and such that xn=Last(V) participates of
#this cover by covering some xs < z < xn.
CoverWithXsZrXn:=function(Grp,V,S) 
  local Grp1,Grp2,g,lg,Z,X,V0,V1,S1,n,xn,xs,i,z;
  if V=[] then return false; fi;
  n:=Length(V);xn:=V[n];
  X:=V{[1..n-1]};
  for xs in X do #Print("xs=",xs,"\n");
    g:=Transporter(Grp,xn,xs);
    if g=fail then continue; fi;
    Grp1:=yStab(Grp,xs);
    Z:=Intersection([xs..xn],S);
    Z:=Difference(Z,V);
    for z in Z do #Print("z=",z,"\n");
      V1:=Concatenation([z],Filtered(X,w->w<z));
      V1:=Difference(V1,[xs]);
      #optimize by processing chunks [xi..xj],[zk], etc.
      lg:=Cover(Grp1,V1,OnTuples(X,g));
      if lg=fail then continue; fi;
      #Print(V,">",OnSets(Set(V),g*lg),"; g*lg = ",g*lg,"\n");#test correctness
      return lg; 
    od;
  od;
  return fail; 
end;

#Grp is a group, V is a Vector,
#S is auxiliary. S contains V and is Grp-invariant.
#Determines whether there is a g in G such that
#V^g < V 
PreviouslyConsidered:=function(Grp,V,S)
  if IsTrivial(Grp) then return false; fi;
  if CoverWithZrXn(Grp,V,S)<> fail then 
    return true;
  fi;
  if CoverWithXsZrXn(Grp,V,S)<> fail then 
    return true;
  fi;
  return false;
end;

#####################################
###########   PrevCons 1  ###########
#####################################
# Descarta construyendo el árbol de la órbita
# 'E' es conjunto. Lento para casos grandes. 
Reduce:=function(Grp,E) 
   local gens,numgens,orb,tree,permid,elms,i,j,h,g,x,y,pos;
   if E=[1..Length(E)] then return fail; fi;
   gens:=GeneratorsOfGroup(Grp);
   numgens:=Length(gens);
   E:=Immutable(E);
   orb:=[E]; elms:=Set([E]);
   tree:=[0];
   permid:=[0];
   i:=1;
   while i<= Length(orb) do
     for j in [1..numgens] do
       x:=orb[i];g:=gens[j];
       y:=OnSets(x,g);
       y:=MakeImmutable(y);
       if y < E then #end,return
          #Next 4 lines are just for testing correctness. 
          h:=g;pos:=i;
          while pos>1 do
            h:=gens[permid[pos]]*h;
            pos:=tree[pos];
          od;
          #FIXME: for testing, remove later:
          #Print("OnSets(",e,"^",h,") = ",OnSets(e,h)," = ",y,"\n");
          return y;
       elif not y in elms then #store 
          AddSet(elms,y);
          Add(orb,y);
          Add(tree,i);
          Add(permid,j);
       fi; #else continue;
     od;
     i:=i+1;
   od;
   return fail;
end;

#Original procedure. Slow for large cases.
#S is not used, it is present for homogeinity 
# with Previouslyconsidered().
PreviouslyConsidered1:=function(Grp,E,S) 
   #Print(E,"\n");
   if IsTrivial(Grp) then return false; fi;
   return Reduce(Grp,E)<> fail;
end;

#Selects method based on the size of SchooseE
PrevCons:=function(Grp,E,S)
  local SchooseE;
  if IsTrivial(Grp) then return false; fi;
  SchooseE:=NrCombinations(S,Length(E));
  if usePrevCons1=infinity or  SchooseE < Int(2^usePrevCons1) then
    return PreviouslyConsidered1(Grp,E,S);
  else
    return PreviouslyConsidered(Grp,E,S);
  fi;
end;

# Returns the k-subsets of S one at a time, using
# PreviouslyConsidered(Grp,S{L})
# L:= indices of current solution
# Check(L) user-provided cut condition.
##################
ChooseNext:=function(S,k,Grp,Check,L) 
  local L0,i,n,L1,Grp1;
  n:=Length(S);
  if L=[fail] and not Check([]) then 
     return fail; 
  fi;
  #### Invalid and base cases: 
  if n<0 or k<=0 or k>n then 
    if n<0 or k<0 or k>n or L<>[fail] then 
      while L<>[] do Remove(L); od;
      L[1]:=fail;
      return fail; 
    else #k=0, L=[fail]
      Remove(L);
      return [];
    fi;
  fi;
  ############### Compute Next Case:
  i:=Length(L);  
  if i>k then Error("Length(L)>k"); fi;
  if i=0 or L=[fail] then #Start
    L[1]:=1; 
    i:=1;
  elif i<k and n-L[i] >= k-i then ## Forth
    # n-L[i] = elegible; k-i = to be elected.
    L[i+1]:=L[i]+1;
    i:=i+1;
  elif n-L[i] >= k-i+1 then ## Next
    L[i]:=L[i]+1;
  else # n-L[i] < k-i+1   ## Back
    Unbind(L[i]);
    i:=i-1;
    if i=0 then   
      L[1]:=fail;
      return fail;                             
    fi;
    L[i]:=L[i]+1;
 fi;
  ###############
  repeat 
    #Print(L,"\n");
    if not Check(S{L}) or PrevCons(Grp,S{L},S) then
      if n-L[i] < k-i+1 then  ## Back
        Unbind(L[i]);
        i:=i-1;
        if i=0 then break; fi; 
      fi; 
      L[i]:=L[i]+1; ## Next
      continue;
    elif i=k then
      return S{L};
    elif n-L[i] >= k-i then #i<k  ## Forth
      L[i+1]:=L[i]+1;
      i:=i+1;
      continue;
    else # n-L[i] < k-i ## Back and Next
      Unbind(L[i]);
      i:=i-1;
      if i=0 then break; fi; 
      L[i]:=L[i]+1;
      continue;
    fi; 
  until false;
  L[1]:=fail;
  return fail;                             
end;

Choose:=function(S,k,Grp,Check) 
  local bag,L,next;
  bag:=[];L:=[fail];
  next:= ChooseNext(S,k,Grp,Check,L);
  while next <>fail do; 
    Add(bag,next);
    next:= ChooseNext(S,k,Grp,Check,L);
  od;
  return bag;
end;
