#This version reimplements stabilizer.
#We beat GAP on this!!


#########################################
#
# Orbits, transporters, trees for points.
#
##########################################


IsBoundTreeWithE:=function(Grp,e) 	#Check if the tree containing "e" has already been made.
  return IsBound(Grp!.y) and IsBound(Grp!.y.root[e]); 
end;

TreeWithE:=function(Grp,e)		#Returns the tree containing "e".
    local gens,orb,n,T,P,S,i,x,y,g;
      gens:=GeneratorsOfGroup(Grp);
      n:=LargestMovedPoint(Grp);

    if IsBoundTreeWithE(Grp,e) then
       return Grp!.y;
    elif not IsBound(Grp!.y) then 
      Grp!.y:=rec(
       root:=EmptyPlist(n),            #The roots of all elements. not bound = unknown.
       parent:=EmptyPlist(n),          #The parents. 0=doesn't have, not Bound = unknown.
       trans:=EmptyPlist(n),           #x=root[x]^trans[x]. not Bound=unknown.
       ptrans:=EmptyPlist(n),          #e=parent[e]^ptrans[e]. not Bound=unknown.
       orb:=[],                        #list of orbit with holes.           
                                       #Only the roots will have an assigned orbit.
       genStabI:=[],                   #list of root stabilizer generators (indicated).
                                       #with holes.
       genStab:=[],                    #list of stabilizer generators (calculated and reduced).
       StabG:=[],                      #list of stabilizers.
  
      );
#      Print("***\n");
    fi;
    Grp!.y.root[e]:=e;
    Grp!.y.parent[e]:=0;
    Grp!.y.ptrans[e]:=One(Grp);
    Grp!.y.orb[e]:=[e];
    Grp!.y.genStabI[e]:=[];
    Grp!.y.trans[e]:=One(Grp);
    i:=1;
    while i<= Length(Grp!.y.orb[e]) do
      x:=Grp!.y.orb[e][i];
      for g in gens do
        y:=x^g;
        if not IsBound(Grp!.y.parent[y]) then #not previously considered, store. 
          Grp!.y.root[y]:=e;        
          Grp!.y.parent[y]:=x;        
          Grp!.y.ptrans[y]:=g;
          Add(Grp!.y.orb[e],y);
        else
          Add(Grp!.y.genStabI[e],[x,g,y]);
        fi; 
      od;
      i:=i+1;
   od;
   return Grp!.y;
end;


RootE:=function(Grp,e)                  #Returns the root of"e"
    local tree; 
    tree:= TreeWithE(Grp,e); #tree:=Grp!.y
    return tree.root[e];
end;


EquivEF:=function(Grp,e,f)              #Check if "e" and "f" are in the same tree.
   local cond;

   cond:=[IsBoundTreeWithE(Grp,e),IsBoundTreeWithE(Grp,f)];

   if cond =[true,false] or cond = [false, true] then 
      return false;
   elif cond = [true, true] then 
      return RootE(Grp,e)=RootE(Grp,f); 
   else #cond =[false, false]: both trees not present.
      TreeWithE(Grp,e);
      return IsBoundTreeWithE(Grp,f); #RootE(Grp,e)=RootE(Grp,f)
   fi;
end;

RootTrans:=function(Grp,e)  #Returns transporter from root to e. For internal use.
  local root,parent,perm,parentlist,permlist,trans,m,i;

  if IsBound(Grp!.y) and IsBound(Grp!.y.trans[e])  then 
     return Grp!.y.trans[e];
  fi;
  m:=0;
  root:=RootE(Grp,e);  
  parent:=e;permlist:=[];parentlist:=[];
  while not IsBound(Grp!.y.trans[parent]) do #      
     perm:=Grp!.y.ptrans[parent];
     Add(permlist,perm);     
     Add(parentlist,parent);
     parent:=Grp!.y.parent[parent];
     m:=m+1;
  od;
  perm:=Grp!.y.trans[parent];
  for i in [m,m-1..1] do 
     perm:= perm*permlist[i];
     Grp!.y.trans[parentlist[i]]:=perm;
     #Print("trans(",parentlist[i],")\n");    
  od;
  return perm; # = Grp!.y.trans[e];
end;

Transporter:=function(Grp,e,f)             #Returns the transporter from e to f.
  if not EquivEF(Grp,e,f) then return fail; fi;
  return LeftQuotient(RootTrans(Grp,e),RootTrans(Grp,f));
end;

yStab:=function(Grp,e) 
  local y,root,trans,genI,gen;
  if IsTrivial(Grp) or not e in MovedPoints(Grp) then 
    return Grp;
  fi;

  y:=TreeWithE(Grp,e);
  if IsBound(y.genStab[e]) then 
    return y.StabG[e]; 
  fi;
  root:=y.root[e];
  if not IsBound(y.genStab[root]) then
    y.genStab[root]:=[];
    for genI in y.genStabI[root] do 
      gen:=RootTrans(Grp,genI[1])*genI[2]*RootTrans(Grp,genI[3])^-1;
      if gen=() then continue; fi;
      AddSet(y.genStab[root],gen);
    od;
    if y.genStab[root]=[] then y.genStab[root]:=[()]; fi;
    y.StabG[root]:=Group(y.genStab[root]);
  fi;
  if e=root then
    #Assert(1,y.StabG[e]=Stabilizer(Grp,e));
    return y.StabG[root]; 
  fi;
  trans:=RootTrans(Grp,e);
  #Conjugate generators and group.
  y.genStab[e]:=List(y.genStab[root],z->z^trans);
  y.StabG[e]:=Group(y.genStab[e]);
     #Do not try this instead: 
     #y.StabG[e]:=y.StabG[root]^trans; #slower
  #Assert(1,y.StabG[e]=Stabilizer(Grp,e));
  return y.StabG[e];
end;
